<?php
/* --------------------------------------------------------------
   TrackingCodeId.php 2020-03-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Model;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeId as TrackingCodeIdInterface;
use Webmozart\Assert\Assert;

/**
 * Class TrackingCodeId
 *
 * @package Gambio\Admin\TrackingCode\Model
 */
class TrackingCodeId implements TrackingCodeIdInterface
{
    /**
     * @var int|null
     */
    private $id;
    
    
    /**
     * TrackingCodeId constructor.
     *
     * @param int $id
     */
    private function __construct(?int $id)
    {
        $this->id = $id;
    }
    
    
    public static function create(?int $id = null): TrackingCodeId
    {
        if ($id !== null) {
            Assert::greaterThan($id, 0, 'Invalid ID value provided. Got: %s');
        }
        
        return new self($id);
    }
    
    
    /**
     * @inheritDoc
     */
    public function value(): ?int
    {
        return $this->id;
    }
    
    
    /**
     * @inheritDoc
     */
    public function jsonSerialize(): ?int
    {
        return $this->value();
    }
}